/*==========================================================================
  SBLIT.C

  Example code to perform a simple one to one bitblt.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int srcx, srcy;
    int dstx, dsty;
    int width, height;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // set engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // setup dimensions for blit
    srcx = modeinfo.xres / 32;
    srcy = modeinfo.yres / 32;
    width = modeinfo.xres / 4;
    height = modeinfo.yres / 4;

    dstx = modeinfo.xres - (modeinfo.xres / 4) - (modeinfo.xres / 32);
    dsty = modeinfo.yres - (modeinfo.yres / 4) - (modeinfo.yres / 32);

    // draw a filled rectangle which will be used as the blit source
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (srcx, srcy, width, height);

    set_fg_color (get_color_code (LIGHTRED));
    draw_rectangle (srcx + (modeinfo.xres / 32),
                    srcy + (modeinfo.yres / 32),
                    width - (2 * (modeinfo.xres / 32)),
                    height - (2 * (modeinfo.yres / 32)));

    set_fg_color (get_color_code (LIGHTBLUE));
    draw_rectangle (srcx + (modeinfo.xres / 16),
                    srcy + (modeinfo.yres / 16),
                    width - (2 * (modeinfo.xres / 16)),
                    height - (2 * (modeinfo.yres / 16)));

    // Setup for simple one-to-one color blit:
    //
    //    The monochrome path controls which source channel is used to read
    //    the source data. If the monochrome path is "1", the foreground
    //    channel is selected as the source; if the monochrome path is "0",
    //    the background channel is selected. In this case, the monochrome
    //    path will be set to "1".
    //

    getch ();
    wait_for_fifo (1);
    regw (DP_SRC, MONO_SRC_ONE | FRGD_SRC_BLIT);

    // Draw a simple one-to-one color blit:
    //
    //    The source data is at (srcx, srcy) and has a size of
    //    (width, height). The destination of the blit will be drawn at
    //    (dstx, dsty).
    //
    blit (srcx, srcy, dstx, dsty, width, height);

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

